--> pralable
-- USE BD_Air_France;



IF OBJECT_ID('dbo.T_affreter_aff','U') IS NOT NULL
   DROP TABLE dbo.T_affreter_aff;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_effectif INT, cmp_ville VARCHAR(30), cmp_nom VARCHAR(30));

CREATE TABLE T_avion_avi
(avi_immat VARCHAR(6), avi_typ VARCHAR(30), avi_hv DECIMAL(10,2),
 cmp_comp VARCHAR(4));

CREATE TABLE T_affreter_aff
(cmp_comp VARCHAR(4), avi_immat VARCHAR(6), aff_datea DATE, aff_nbp SMALLINT);

ALTER TABLE T_affreter_aff
      ADD   aff_numero  INT IDENTITY NOT NULL;
GO
ALTER TABLE T_affreter_aff 
      ADD CONSTRAINT PK_aff PRIMARY KEY(aff_numero);
GO
ALTER TABLE T_compagnie_cmp
      ALTER COLUMN cmp_comp VARCHAR(4) NOT NULL;
GO
ALTER TABLE T_compagnie_cmp
      ADD CONSTRAINT PK_cmp PRIMARY KEY(cmp_comp);
GO
ALTER TABLE T_avion_avi
      ALTER COLUMN avi_immat VARCHAR(6) NOT NULL;
GO
ALTER TABLE T_avion_avi
      ADD CONSTRAINT PK_avi PRIMARY KEY(avi_immat);
GO

ALTER TABLE T_avion_avi
      ALTER COLUMN cmp_comp VARCHAR(4) NULL;

ALTER TABLE T_affreter_aff
      ALTER COLUMN cmp_comp  VARCHAR(4) NOT NULL;

ALTER TABLE T_affreter_aff
      ALTER COLUMN avi_immat VARCHAR(6) NOT NULL;

ALTER TABLE T_affreter_aff
      ADD CONSTRAINT FK_aff_cmp FOREIGN KEY(cmp_comp) 
                                REFERENCES T_compagnie_cmp(cmp_comp)
                                ON DELETE CASCADE
                                ON UPDATE NO ACTION ;
ALTER TABLE T_avion_avi
      ADD CONSTRAINT FK_avi_cmp FOREIGN KEY(cmp_comp) 
                                REFERENCES T_compagnie_cmp(cmp_comp)
                                ON DELETE SET NULL
                                ON UPDATE NO ACTION;
ALTER TABLE T_affreter_aff
      ADD CONSTRAINT FK_aff_avi FOREIGN KEY(avi_immat) 
                                REFERENCES T_avion_avi(avi_immat)
                                ON DELETE NO ACTION
                                ON UPDATE NO ACTION;

INSERT INTO T_compagnie_cmp(cmp_comp,cmp_effectif,cmp_ville,cmp_nom)
       VALUES ('AF',6700,'Paris', 'Air France');
INSERT INTO T_compagnie_cmp(cmp_comp,cmp_effectif,cmp_ville,cmp_nom)
       VALUES ('SING',3400,'Singapour','Singapore AL');

INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-WTSS','B777',6570,'SING');

INSERT INTO T_affreter_aff(cmp_comp,avi_immat,aff_datea,aff_nbp)
       VALUES('AF','F-WTSS','2013-05-13',250);

SELECT * FROM T_affreter_aff;
SELECT * FROM T_avion_avi;
SELECT * FROM T_compagnie_cmp;


ALTER TABLE T_avion_avi WITH NOCHECK 
            ADD CONSTRAINT CK_hv_avi CHECK (avi_hv < 500);

INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-GHID','A330',700,'AF');

-- dsactivation contrainte FK avant entre avion et compagnie

ALTER TABLE T_avion_avi NOCHECK CONSTRAINT FK_avi_cmp;

INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-HDGL','A340',200,'EJET');


